package topdown.operator;

import topdown.data_structures.*;
import topdown.concrete_operator.*;
import topdown.term.Term;
import topdown.term.Variable;

import java.util.ArrayList;
import java.util.List;

public class Join implements Operator {
    // "Big Join" - joins n operators
    private final List<Operator> operators;
    private final List<List<Term>> inputV;
    private final List<Term> outputV;

    public Join(List<Operator> operators, List<List<Term>> inputV, List<Term> outputV) {
        this.operators = operators;
        this.inputV = inputV;
        this.outputV = outputV;
    }

    @Override
    public ConcreteOperator instance() {
        List<ConcreteOperator> concreteOperators = new ArrayList<>();
        for (Operator op : operators) {
            concreteOperators.add(op.instance());
        }

        ConcreteJoin result = new ConcreteJoin(
            concreteOperators, inputV, outputV
        );
        result.reset();
        return result;
    }

    @Override
    public ConcreteOperator instance(int U, int L) {
        if (U <= 0 || L <= 0) return new EmptyOperator();

        List<ConcreteOperator> concreteOperators = new ArrayList<>();
        for (Operator op : operators) {
            concreteOperators.add(op.instance(U, L));
        }

        ConcreteJoin result = new ConcreteJoin(
                concreteOperators, inputV, outputV
        );

        return result;
    }

    @Override
    public boolean changes(int U, int L) {
        for (Operator op : operators) {
            if (op.changes(U, L)) return true;
        }

        return false;
    }

    @Override
    public boolean changes(int U) {
        for (Operator op : operators) {
            if (op.changes(U)) return true;
        }

        return false;
    }
}
